<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:mml="http://www.w3.org/1998/Math/MathML"
    version="1.0">
    
    <xsl:output method="xml" />
    
    <xsl:template match="node()|@*">
        <xsl:copy>
            <xsl:apply-templates select="node()|@*"/>
        </xsl:copy>        
    </xsl:template>
     
    <!-- ================================================================================================
        
        fix Direc (Bra-Ket) expressions
        
        ================================================================================================ -->
    
    <xsl:variable name="BraOpenSym" select="'⟨'" />
    <xsl:variable name="BraCloseSym" select="'|'" />
    <xsl:variable name="KetCloseSym" select="'⟩'" />
    <xsl:variable name="KetOpenSym" select="'|'" />
    
    <!-- match pattern '<' single-node 'mfenced|>' -->
    <xsl:template match="mml:mo[text()='⟨' and following-sibling::*[2][ local-name()='mfenced' and @open='|' and @close='⟩']]">
        
        <mml:mfenced>
            <xsl:attribute name="open"><xsl:value-of select="$BraOpenSym"/></xsl:attribute>
            <xsl:attribute name="close"><xsl:value-of select="$KetCloseSym"/></xsl:attribute>
            <xsl:attribute name="separators"><xsl:value-of select="$BraCloseSym"/></xsl:attribute>
            <mml:mrow>
                <!--<xsl:copy-of select="following-sibling::*[1]"/>-->
                <xsl:copy-of select="following-sibling::*[1]"/>
            </mml:mrow>
            <!--            <xsl:copy-of select="following-sibling::*[2]/*"/>-->
            <xsl:apply-templates select="following-sibling::*[2]/*"/>
        </mml:mfenced>
        
    </xsl:template>
    
    <xsl:template match="node()[preceding-sibling::*[1][local-name()='mo' and text()='⟨'] and following-sibling::*[1][local-name()='mfenced' and @open='|' and @close='⟩']]"/>
    <xsl:template match="mml:mfenced[ @open='|' and @close='⟩' and preceding-sibling::*[2][local-name()='mo' and text()='⟨']]"/>
    
    <!-- match pattern '<' single-node '|' -->
    <xsl:template match="mml:mo[text()='⟨' and following-sibling::*[2][ local-name()='mo' and text()='|']]">
        
        <mml:mfenced>
            <xsl:attribute name="open"><xsl:value-of select="$BraOpenSym"/></xsl:attribute>
            <xsl:attribute name="close"><xsl:value-of select="$BraCloseSym"/></xsl:attribute>
            <!--<xsl:copy-of select="following-sibling::*[1]"/>-->
            <xsl:copy-of select="following-sibling::*[1]"/>
        </mml:mfenced>
        
    </xsl:template>
    
    <xsl:template match="node()[preceding-sibling::*[1][local-name()='mo' and text()='⟨'] and following-sibling::*[1][local-name()='mo' and text()='|']]"/>
    <xsl:template match="node()[local-name()='mo' and text()='|'and preceding-sibling::*[2][local-name()='mo' and text()='⟨']  ]"/>
    
    <!-- match pattern '|' single-node '>' -->
    <xsl:template match="mml:mo[text()='|' and following-sibling::*[2][ local-name()='mo' and text()='⟩']]">
        
        <mml:mfenced>
            <xsl:attribute name="open"><xsl:value-of select="$KetOpenSym"/></xsl:attribute>
            <xsl:attribute name="close"><xsl:value-of select="$KetCloseSym"/></xsl:attribute>
            <!--<xsl:copy-of select="following-sibling::*[1]"/>-->
            <xsl:copy-of select="following-sibling::*[1]"/>
        </mml:mfenced>
        
    </xsl:template>
    
    <xsl:template match="node()[preceding-sibling::*[1][local-name()='mo' and text()='|'] and following-sibling::*[1][local-name()='mo' and text()='⟩']]"/>
    <xsl:template match="node()[local-name()='mo' and text()='⟩'and preceding-sibling::*[2][local-name()='mo' and text()='|']  ]"/>


	<!-- ================================================================================================
        
        combine msub with adjacent primes into msubsup
        
        ================================================================================================ -->
    <xsl:template match='mml:msub[following-sibling::*[1][local-name()="mi" and text()="&#x0027;" or text()="&#x2019;"]]'>
        
        <xsl:variable name="name" select="local-name()"/>
        <xsl:variable name="mmlPrefix" select="substring-before(name(), concat(':',local-name()))"/>            
        <xsl:variable name="msubsupQName">
            <xsl:if test="not($mmlPrefix='')"><xsl:value-of select="$mmlPrefix"/><xsl:text>:</xsl:text></xsl:if>
            <xsl:text>msubsup</xsl:text>
        </xsl:variable>
        
        <xsl:element name="{$msubsupQName}" namespace="{namespace-uri()}">
            <xsl:apply-templates select="@*"/>                                      <!-- Copy attributes of context -->
            <xsl:apply-templates/>                                                  <!-- Copy children of context -->
            <xsl:apply-templates select="following-sibling::*[1]" mode="first"/>    <!-- Add prime as sup node -->
        </xsl:element>
        
    </xsl:template>


	<!-- ================================================================================================
        
        fix combining chars in mover/munder/munderover operators
        
        ================================================================================================ -->
    
    <xsl:template name="ToNonCombining">
        <xsl:param name="ch" />
        <xsl:choose>
            <!-- DOUBLE OVERLINE -->
            <xsl:when test="$ch='&#x33F;'">&#x2017;</xsl:when>            
            <!--<xsl:when test="$ch='&#x033F;'">&#x21C0;</xsl:when>-->            
            <!-- LEFT RIGHT ARROW -->
            <xsl:when test="$ch='&#x20E1;'">&#x2194;</xsl:when>
            <!-- LEFT HARPOON ARROW -->
            <xsl:when test="$ch='&#x20D0;'">&#x21BC;</xsl:when>
            <!-- RIGHT HARPOON ARROW -->
            <xsl:when test="$ch='&#x20D1;'">&#x21C0;</xsl:when>
            
            <xsl:otherwise>
                <xsl:value-of select="$ch"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
<!--
    <xsl:template match="mml:mo[parent::mml:mover and position()=1 and string-length(text())=1]">
        <xsl:variable name="chAcc" select="text()"/>
        <xsl:variable name="chNonComb">
            <xsl:call-template name="ToNonCombining">
                <xsl:with-param name="ch" select="$chAcc" />
            </xsl:call-template>
        </xsl:variable>
        <xsl:copy>
            <xsl:value-of select="$chNonComb"/>
        </xsl:copy>
        
    </xsl:template>
-->    
    <!-- ================================================================================================

            (1) OVERLINE (U+2032)           from            HYPHEN-MINUS (U+002D)
            
                if used as accent


            (2) MINUS SIGN (U+2212)         from            HYPHEN-MINUS (U+002D)

                in all other cases
        
        ================================================================================================ -->

<!--
    <xsl:template match="mml:mo[text()='&#x002D;']">
        <xsl:variable name="currentNodeID" select="generate-id(current())"></xsl:variable>
        <xsl:variable name="opSym">
            <xsl:choose>
                <xsl:when test="generate-id(ancestor::mml:mover/child::*[2]/descendant-or-self::mml:mo)=$currentNodeID">
                    <xsl:text>&#x203e;</xsl:text>
                </xsl:when>
                <xsl:otherwise><xsl:text>&#x2212;</xsl:text></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:copy>
            <xsl:value-of select="$opSym"/>
        </xsl:copy>
    </xsl:template>
-->
    
    <xsl:template match="mml:mo">
        <xsl:variable name="currentNodeID" select="generate-id(current())"></xsl:variable>
        <xsl:variable name="parentIsSingleChild_mrow" select="local-name(parent::node())='mrow' and count(parent::node()/child::*)=1" />
        <xsl:variable name="isDirectChild" select="local-name(parent::node())='munder' or local-name(parent::node())='mover' or local-name(parent::node())='mml:munderover'" />
        
        <xsl:variable name="opSym">
            <xsl:choose>
                <!-- HYPHEN-MINUS (U+002D) to OVERLINE(U+2032) or MINUS SIGN(U+2212) -->
                <xsl:when test="text()='&#x002D;'"> 
                    <xsl:choose>
                        <xsl:when test="generate-id(ancestor::mml:mover/child::*[2]/descendant-or-self::mml:mo)=$currentNodeID and ($isDirectChild or $parentIsSingleChild_mrow)">
                            <xsl:text>&#x203e;</xsl:text>
                        </xsl:when>
                        <xsl:when test="generate-id(ancestor::mml:munder/child::*[2]/descendant-or-self::mml:mo)=$currentNodeID  and ($isDirectChild or $parentIsSingleChild_mrow)">
                            <xsl:text>&#x203e;</xsl:text>
                        </xsl:when>
                        <xsl:when test="generate-id(ancestor::mml:munderover/child::*[2]/descendant-or-self::mml:mo)=$currentNodeID and ($isDirectChild or $parentIsSingleChild_mrow)">
                            <xsl:text>&#x203e;</xsl:text>
                        </xsl:when>
                        <xsl:when test="generate-id(ancestor::mml:munderover/child::*[3]/descendant-or-self::mml:mo)=$currentNodeID and ($isDirectChild or $parentIsSingleChild_mrow)">
                            <xsl:text>&#x203e;</xsl:text>
                        </xsl:when> 
                        <xsl:otherwise><xsl:text>&#x2212;</xsl:text></xsl:otherwise>
                    </xsl:choose>                    
                </xsl:when>
                <xsl:otherwise>
                    <!--  -->                    
                    <xsl:variable name="myParentIsMrow" select="local-name(parent::node())='mrow'"/>
                    <!-- first arg in mover/munder/munderover? -->                    
                    <xsl:variable name="moInFirstArg">
                        <xsl:choose>
                            <xsl:when test="$myParentIsMrow">
                                <xsl:value-of select="generate-id((../parent::mml:mover|../parent::mml:munder|../parent::mml:munderover)/child::*[2]/descendant-or-self::mml:mo)=$currentNodeID"/></xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of  select="generate-id((parent::mml:mover|parent::mml:munder|parent::mml:munderover)/child::*[2]/descendant-or-self::mml:mo)=$currentNodeID"/> </xsl:otherwise>
                        </xsl:choose>                        
                    </xsl:variable>
                    <!-- second arg in munderover? -->                    
                    <xsl:variable name="moInSecondArg">
                        <xsl:choose>
                            <xsl:when test="$myParentIsMrow">
                                <xsl:value-of select="generate-id(../parent::mml:munderover/child::*[3]/descendant-or-self::mml:mo)=$currentNodeID"/></xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of  select="generate-id(parent::mml:munderover/child::*[3]/descendant-or-self::mml:mo)=$currentNodeID"/> </xsl:otherwise>
                        </xsl:choose>                        
                    </xsl:variable>
                    <!-- is it a single mo/mi/mn element the mo is applied to? -->                    
                    <xsl:variable name="singleCharMainArg">
                        <xsl:choose>
                            <xsl:when test="($moInFirstArg or $moInSecondArg)">
                                <xsl:choose>
                                    <xsl:when test="$myParentIsMrow">
                                        <xsl:value-of select="count((../parent::mml:mover|../parent::mml:munder|../parent::mml:munderover)/child::*[1][(local-name()='mrow' and count(child::*)=1) or local-name()='mo' or local-name()='mi' or local-name()='mn'])=1"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="count((parent::mml:mover|parent::mml:munder|parent::mml:munderover)/child::*[1][(local-name()='mrow' and count(child::*)=1) or local-name()='mo' or local-name()='mi' or local-name()='mn'])=1"/>                                    </xsl:otherwise>
                                </xsl:choose>                        
                            </xsl:when>
                            <xsl:otherwise><xsl:value-of select="false()"/></xsl:otherwise>
                        </xsl:choose>
                    </xsl:variable>
                    
                    <!--  -->
                    <xsl:choose>
                        <xsl:when test="$singleCharMainArg='true'">
                            <xsl:value-of select="."/>
                        </xsl:when>
                        <xsl:otherwise>
                            <!-- Otherwise: Remap characters like combining diacritics, etc -->
                            <xsl:call-template name="ToNonCombining">
                                <xsl:with-param name="ch" select="text()" />
                            </xsl:call-template>                           
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:value-of select="$opSym"/>
        </xsl:copy>
    </xsl:template>



    <!-- ================================================================================================
        
                                PRIME (U+2032-2034,2057)

                                        from

               Apostroph (U+0027) and  RIGHT SINGLE QUOTATION MARK (U+2019) 
               
               
        
        Match adjacent mi elements with Apostroph (U+0027) and  RIGHT SINGLE QUOTATION MARK (U+2019)

        Recursive approach to find adjacent mi nodes and convert them to a single combined prime mo
        
        ================================================================================================ -->
  
    <xsl:template match='mml:mi[text()="&#x0027;" or text()="&#x2019;"]'>
        <xsl:if test='not(preceding-sibling::*[1][local-name()="msub"])'>
            <xsl:apply-templates select="." mode="first"/>
        </xsl:if>
    </xsl:template>
        
    <xsl:template match='mml:mi[text()="&#x0027;" or text()="&#x2019;"]' mode="first">
        
        <xsl:variable name="name" select="local-name()"/>
        <xsl:variable name="mmlPrefix" select="substring-before(name(), concat(':',local-name()))"/>            
        <xsl:variable name="moQName">
            <xsl:if test="not($mmlPrefix='')"><xsl:value-of select="$mmlPrefix"/><xsl:text>:</xsl:text></xsl:if>
            <xsl:text>mo</xsl:text>
        </xsl:variable>
        
        
        <!-- Is this the first element in a sequence? -->
        <xsl:if test='local-name(preceding-sibling::*[position()=1]) != $name or preceding-sibling::*[position()=1] != text()'>
            
            <xsl:element name="{$moQName}" namespace="{namespace-uri()}">
                <!-- Copy attributes of first element -->
                <xsl:apply-templates select="@*"/>
                
                <!-- Match the next sibling if it has the same name -->
                <xsl:choose>
                    <xsl:when test='following-sibling::*[1][local-name()=$name and (text()="&#x0027;" or text()="&#x2019;")]'>
                        <xsl:apply-templates select='following-sibling::*[1][local-name()=$name and (text()="&#x0027;" or text()="&#x2019;")]' mode="next">
                            <xsl:with-param name="primeCount" select="2"/>
                        </xsl:apply-templates>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>&#x2032;</xsl:text> <!-- single prime -->
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>
        </xsl:if>
    </xsl:template>

    <!-- Recursive template used to match the next sibling if it has the same name -->
    <xsl:template match='mml:mi[text()="&#x0027;" or text()="&#x2019;"]' mode="next">
        <xsl:param name="primeCount"/>
        <xsl:variable name="name" select="local-name()"/>
        <xsl:choose>
            <xsl:when test='following-sibling::*[1][local-name()=$name and (text()="&#x0027;" or text()="&#x2019;")]'>
                <xsl:apply-templates select='following-sibling::*[1][local-name()=$name and (text()="&#x0027;" or text()="&#x2019;")]' mode="next">
                    <xsl:with-param name="primeCount" select="$primeCount+1"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>           
                <!-- output the unicode for the prime char -->                
                <xsl:value-of select="translate($primeCount,'1234','&#x2032;&#x2033;&#x2034;&#x2057;')"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    
    <!-- ================================================================================================

            mfrac/@linethickness  ==> revert to "0" unless != 0
        
        ================================================================================================ -->

    <xsl:template match="mml:mfrac[@linethickness]">
        <xsl:variable name="linethicknessVal" select="translate(@linethickness,'/% abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ',' ')"/>
        <xsl:variable name="linethickness">
            <xsl:choose>
                <xsl:when test="number($linethicknessVal)=0">0</xsl:when>
                <xsl:otherwise><xsl:value-of select="@linethickness"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:element name="{name()}"  namespace="{namespace-uri()}">
            <xsl:attribute name="linethickness"><xsl:value-of select="$linethickness"/></xsl:attribute>
            <xsl:apply-templates select="@*[name()!='linethickness']"/>
            <xsl:apply-templates/>
            
        </xsl:element>
    </xsl:template>
    
</xsl:stylesheet>
